<?php

class Cart extends CI_Controller {
	
	//we collect the categories automatically with each load rather than for each function
	//this just cuts the codebase down a bit
	var $categories	= '';
	var $categories1	= '';
	var $categories2	= '';
	var $categories3	= '';
	var $categories4	= '';
	//load all the pages into this variable so we can call it from all the methods
	var $pages = '';
	
	// determine whether to display gift card link on all cart pages
	//  This is Not the place to enable gift cards. It is a setting that is loaded during instantiation.
	var $gift_cards_enabled; 
	
	var $header_text;

	function __construct()
	{
		
		parent::__construct();
		
		//make sure we're not always behind ssl
		//remove_ssl();
		
		$this->load->library('Go_cart');
		$this->load->model(array('Page_model', 'Product_model', 'Blog_model', 'Brand_model',  'Color_model', 'Digital_Product_model', 'Gift_card_model', 'Option_model', 'Order_model', 'Settings_model'));
		$this->load->helper(array('form_helper', 'formatting_helper'));
		
		//fill in our variables
		$this->categories	= $this->Category_model->get_categories_tierd(0);
		$this->categories1	= $this->Category_model->get_categories_tierd(29);
		//$this->categories2	= $this->Category_model->get_category(3);
		//$this->categories3	= $this->Category_model->get_category(4);
		//$this->categories4	= $this->Category_model->get_category(5);
		/*$this->categories2	= $this->Category_model->get_categories_tierd(2);
		$this->categories3	= $this->Category_model->get_categories_tierd(3);
	 	$this->categories4	= $this->Category_model->get_categories_tierd(4);
		$this->pages		= $this->Page_model->get_pages();*/
		
		// check if giftcards are enabled
		
		
		//load the theme package
		$this->load->add_package_path(APPPATH.'themes/'.$this->config->item('theme').'/');
		
	}

	function index()
	{
	    
		$this->load->model(array('Banner_model', 'box_model'));
		$this->load->helper('directory');

		$data['homepage']			= true;

		$data['departments']			= $this->Banner_model->get_homepage_banners_by_position(4,'departments');
		$data['factoryViews']			= $this->Banner_model->get_homepage_banners_by_position(20,'factory-view');
		///$data['banners']			= $this->Banner_model->get_homepage_banners(1000);
		$data['boxes']				= $this->box_model->get_homepage_boxes(1000);
		
		$data['categories']  = $this->Category_model->get_categories_tierd(0);
		
		/*echo '<pre>';
		print_r($data);
		die;*/
		
	   //grab the products using the pagination lib
		$data['homeproducts']	= $this->Product_model->get_home_products();
		foreach ($data['homeproducts'] as &$p)
		{
			$p->images	= (array)json_decode($p->images);
			$p->options	= $this->Option_model->get_product_options($p->id);
		}
		
		//grab the products using the pagination lib
		$data['newproducts']	= $this->Product_model->get_new_home_products();
		foreach ($data['newproducts'] as &$p)
		{
			$p->images	= (array)json_decode($p->images);
			$p->options	= $this->Option_model->get_product_options($p->id);
		}


		$data['blogs']	= $this->Blog_model->get_products();
		foreach ($data['blogs'] as &$p)
		{
			$p->images	= (array)json_decode($p->images);
			$p->options	= $this->Option_model->get_product_options($p->id);
		}
			
		//$this->load->view('Homepage', $data);
		 $this->load->view('Home', $data);
	}
	
	
	function newArrivals()
	{
	    
	    
	    $data['newproducts']	= $this->Product_model->get_new_products();
		foreach ($data['newproducts'] as &$p)
		{
			$p->images	= (array)json_decode($p->images);
			$p->options	= $this->Option_model->get_product_options($p->id);
		}
		$this->load->view('NewArrivals', $data);
	}

	function about()
	{
	 
	    $this->load->model(array('Banner_model', 'box_model'));
	 
	    $data['banners']  = $this->Banner_model->get_homepage_banners(1000);
	    $this->load->view('About', $data);
	}
	
	function contact()
	{
		
		if(isset($_REQUEST['email'])){

			$this->load->library('form_validation');

			/*require a billing address*/
			
			$this->form_validation->set_rules('first_name', 'lang:address_firstname', 'trim|required|max_length[32]');
			//$this->form_validation->set_rules('last_name', 'lang:address_lastname', 'trim|required|max_length[32]');
			$this->form_validation->set_rules('email', 'lang:address_email', 'trim|required|valid_email|max_length[128]');
			$this->form_validation->set_rules('phone_no', 'lang:address_phone', 'trim|required|max_length[32]');
			$this->form_validation->set_rules('company', 'lang:address_company', 'trim|max_length[128]');

			//$this->form_validation->set_rules('captcha', 'Captcha', 'required|callback_check_captcha');
			//$this->form_validation->set_rules('token', 'Captcha', 'required|callback_recaptcha_check');
			$this->form_validation->set_rules('g-recaptcha-response', 'Captcha', 'required|callback_recaptcha_check');

			$this->form_validation->set_rules('zip', 'Zip', 'trim|max_length[10]');

			if ($this->form_validation->run() == false){

				$this->session->set_flashdata('error', validation_errors());

				redirect('contact-us');
				die;
				//echo json_encode(array('status'=>'error', 'error'=>validation_errors()));
			}

           $this->load->library('email');
           $config['priority'] = 7;
		   $config['mailtype'] = 'html';

		   $this->email->initialize($config);
           $this->email->from($this->config->item('email_from'), $this->config->item('company_name'));

		   $this->email->reply_to($this->config->item('email_reply'));
           $this->email->to($this->config->item('email'));
            //email the admin

		    $this->email->cc($this->input->post('email'));
		    //$this->email->bcc('noopss.rain@gmail.com');
	    	$this->email->subject('Email Via Contact Us - '.$this->input->post('subject'));
	    	

	    	$html = '';
	    	$html .= 'Name: '.$this->input->post('first_name').'  '.$this->input->post('last_name').'<br>';
	    	$html .= 'Email: '.$this->input->post('email').'<br>';
	    	$html .= 'Subject: '.$this->input->post('subject').'<br>';
	    	$html .= 'Phone: '.$this->input->post('phone_no').'<br>';
	    	$html .= 'Company: '.$this->input->post('company_name').'<br>';
	    	$html .= 'Message: '.$this->input->post('message');

            $this->email->message($html);
		    $this->email->send();

		    redirect('contact-us?confirm=Email has been successufully send.','refresh');
		 }


		$this->load->model(array('Banner_model', 'box_model'));
		$this->load->helper('directory');

		$data['gift_cards_enabled'] = $this->gift_cards_enabled;
		$data['banners']			= $this->Banner_model->get_homepage_banners(5);
		$data['boxes']				= $this->box_model->get_homepage_boxes(4);
		$data['homepage']			= false;
		
		$this->load->view('contact', $data);
	}

	public function recaptcha_check()
	{
		$url = 'https://www.google.com/recaptcha/api/siteverify';
		//$token = $this->input->post('token');
		$token = $this->input->post('g-recaptcha-response');

		$ip = $this->input->ip_address();

		$data = [
			'secret' => '6LdZ_sUpAAAAABRPbbL0ZXtq8ab8nGxqUhuiwyGg',
			'response' => $token,
			'remoteip' => $ip,
		];

		$options = array(
		    'http' => array(
		      'header'  => "Content-type: application/x-www-form-urlencoded\r\n",
		      'method'  => 'POST',
		      'content' => http_build_query($data)
		    )
	  	);
	  	$context  = @stream_context_create($options);
  		$response = @file_get_contents($url, false, $context);

  		$res = json_decode($response, true);
  		
  		//echo "<pre>";print_r($res);exit;
  		if($res['success'] == true) {
  			return true; 
  		}else{
  			return false;
  		}
	}

	function service()
	{

    $data['homepage']  = true;
	$this->load->view('Services', $data);
	
     }
    
    function decoration()
	{

    $data['homepage']  = true;
	$this->load->view('Decoration', $data);
	
     }
     
    function production()
	{

    $data['homepage']  = true;
	$this->load->view('Production', $data);
	
     }
	
	
	function arrivals()
	{
		$this->load->model(array('Banner_model', 'box_model'));
		$this->load->helper('directory');

		$data['gift_cards_enabled'] = $this->gift_cards_enabled;
		$data['banners']			= $this->Banner_model->get_homepage_banners(5);
		$data['boxes']				= $this->box_model->get_homepage_boxes(4);
		$data['homepage']			= true;
		
		 //grab the products using the pagination lib
		$data['products']	= $this->Product_model->get_new_products(0);
		foreach ($data['products'] as &$p)
		{
			$p->images	= (array)json_decode($p->images);
			$p->options	= $this->Option_model->get_product_options($p->id);
		}
		
	    $this->load->view('arrivals', $data);
	}
	
	
	
	
	function ambassador()
	{
		//grab the products using the pagination lib
		$data['products']	= $this->Brand_model->get_products();
		foreach ($data['products'] as &$p)
		{
			$p->images	= (array)json_decode($p->images);
			$p->options	= $this->Option_model->get_product_options($p->id);
		}
		   
	    $this->load->view('ambassador', $data);
	}
	
		function brand($id)
	{
		//get the product
		$data['product']	= $this->Brand_model->get_product($id);
		
		if(!$data['product'] || $data['product']->enabled==0)
		{
			show_404();
		}

		$data['page_title']			= $data['product']->name;
		$data['meta']				= $data['product']->meta;
		$data['seo_title']			= $data['product']->seo_title;
			
		if($data['product']->images == 'false')
		{
			$data['product']->images = array();
		}
		else
		{
			$data['product']->images	= array_values((array)json_decode($data['product']->images));
		}
			
		$this->load->view('brand', $data);
	}
	
	
	
	function media()
	{
		$this->load->model(array('Banner_model', 'box_model'));
		$this->load->helper('directory');

		$data['gift_cards_enabled'] = $this->gift_cards_enabled;
		$data['banners']			= $this->Banner_model->get_homepage_banners(5);
		$data['boxes']				= $this->box_model->get_homepage_boxes(4);
		$data['homepage']			= true;
	   
	    $this->load->view('media', $data);
	}
	
	function blog()
	{
	    //grab the products using the pagination lib
		$data['blogs']	= $this->Blog_model->get_products();
		foreach ($data['blogs'] as &$p)
		{
			$p->images	= (array)json_decode($p->images);
			$p->options	= $this->Option_model->get_product_options($p->id);
		}
		
		$this->load->view('blog', $data);
	}
	
	
	function post($id)
	{
		//get the product
		$data['product']	= $this->Blog_model->get_product($id);
		
		if(!$data['product'] || $data['product']->enabled==0)
		{
			show_404();
		}

        $data['page_title']			= $data['product']->name;
		$data['meta']				= $data['product']->meta;
		$data['seo_title']			= $data['product']->seo_title;
			
		if($data['product']->images == 'false')
		{
			$data['product']->images = array();
		}
		else
		{
			$data['product']->images	= array_values((array)json_decode($data['product']->images));
		}

			
		$this->load->view('post', $data);
	}
	


	


	function page($id)
	{
		$this->load->model('Page_model');
		$data['page']				= $this->Page_model->get_page($id);
		$data['fb_like']			= true;
		$data['page_title']			= $data['page']->title;
		$data['meta']				= $data['page']->meta;

		
		$data['seo_title']			= $data['page']->seo_title;
		
		$data['gift_cards_enabled'] = $this->gift_cards_enabled;
		
		$this->load->view('page', $data);
	}
	
	function search($code=false, $page = 0)
	{

		$this->load->model('Search_model');
		$data['page_title']			= lang('search');
		$data['gift_cards_enabled']	= $this->gift_cards_enabled;
		//check to see if we have a search term
		if(!$code)
		{
			//if the term is in post, save it to the db and give me a reference
			$term		= $this->input->post('term');
			$code		= $this->Search_model->record_term($term);
		}
		else
		{
			//if we have the md5 string, get the term
			$term	= $this->Search_model->get_term($code);
		}

		if(empty($term))
		{
			//if there is still no search term throw an error
			//if there is still no search term throw an error
			$this->session->set_flashdata('error', lang('search_error'));
			redirect('cart');
		}
		else
		{
	
			$data['page_title']	= 'Search';
			$data['gift_cards_enabled'] = $this->gift_cards_enabled;
		
			//set up pagination
			$this->load->library('pagination');
			$config['base_url']		= base_url().'cart/search/'.$code.'/';
			$config['uri_segment']	= 4;
			$config['per_page']		= 20;
	
			$result					= $this->Product_model->search_products($term, $config['per_page'], $page);
			$config['total_rows']	= $result['count'];
			$this->pagination->initialize($config);
	
			$data['products']		= $result['products'];
			foreach ($data['products'] as &$p)
			{
				$p->images	= (array)json_decode($p->images);
				$p->options	= $this->Option_model->get_product_options($p->id);
			}
			$this->load->view('category', $data);
		}
	}
	
	function category($id, $page=0)
	{
		
		//get the category
		$data['category']			= $this->Category_model->get_category($id);



				
		if (!$data['category'])
		{
			show_404();
		}

		$data['subcategories'] = array();

		$subcategories = $this->Category_model->get_categories($data['category']->id);
		if(isset($subcategories) && count((array)$subcategories) > 0){

			$products = array();
			foreach($subcategories as $subcategory){

				$products = $this->Product_model->get_products($subcategory->id, 5, $page);

				$data['subcategories'][] = array(
					'id' => $subcategory->id,
					'parent_id' => $subcategory->parent_id,
					'name' => $subcategory->name,
					'slug' => $subcategory->slug,
					'route_id' => $subcategory->route_id,
					'image' => $subcategory->image,
					'description' => $subcategory->description,
					'products' => $products
				);
			}
		}
		/*
		echo '<pre>';
		print_r($data);
		die;*/

		if ($data['category']->parent_id == 0) {

			
		} else {
			$data['parentCategory']	 = $this->Category_model->get_category($data['category']->parent_id);
			//	$data['subcategories']		= $this->Category_model->get_categories($data['category']->parent_id);
		}

		// echo '<pre>';
		// print_r($data);
		// die;

		$data['product_columns']	= $this->config->item('product_columns');
		$data['gift_cards_enabled'] = $this->gift_cards_enabled;
		
		$data['meta']		= $data['category']->meta;
		$data['seo_title']	= $data['category']->seo_title;
		
		$data['page_title']	= $data['category']->name;
		$data['homepage'] = false;
		
		//set up pagination
		
		$product_count = $this->Product_model->count_products($data['category']->id);
		
		//set up pagination

		$segments	= $this->uri->total_segments();

		$base_url	= $this->uri->segment_array();
		
		
		
		if($data['category']->slug == $base_url[count($base_url)])

		{

			$page	= 0;

			$segments++;

		}

		else

		{

			$page	= array_splice($base_url, -1, 1);

			$page	= $page[0];

		}

		

		$data['base_url']	= $base_url;
		
		$base_url			= implode('/', $base_url);
		
		
		//set up pagination

		$this->load->library('pagination');

		$config['base_url']		= site_url($base_url);

		

		$config['uri_segment']	= $segments;

		$config['per_page']		= 12;

		$config['total_rows']	= $product_count;

		

		$config['first_link'] = 'First';

		$config['first_tag_open'] = '<li>';

		$config['first_tag_close'] = '</li>';

		$config['last_link'] = 'Last';

		$config['last_tag_open'] = '<li>';

		$config['last_tag_close'] = '</li>';



		$config['full_tag_open'] = '<div class="pagination-sec clearfix"><ul class="pagination pagination-sm pull-right">';

		$config['full_tag_close'] = '</ul></div>';

		$config['cur_tag_open'] = '<li class="active"><a href="">';

		$config['cur_tag_close'] = '</a></li>';

		

		$config['num_tag_open'] = '<li>';

		$config['num_tag_close'] = '</li>';

		

		$config['prev_link'] = '&laquo;';

		$config['prev_tag_open'] = '<li>';

		$config['prev_tag_close'] = '</li>';



		$config['next_link'] = '&raquo;';

		$config['next_tag_open'] = '<li>';

		$config['next_tag_close'] = '</li>';

				

		$this->pagination->initialize($config);


		/*$data['products'] =array();
		 foreach($data['subcategories'] as $subcategory){
			$data['products'][$subcategory['id']]	= $this->Product_model->get_products($subcategory['id'], 1000, $page);
		 }


		foreach($data['subcategories'] as $subcategory){	
			foreach ($data['products'][$subcategory['id']] as &$p)
			{
				$p->images	= (array)json_decode($p->images);
				$p->options	= $this->Option_model->get_product_options($p->id);
				$p->colors	= $this->Color_model->get_products($p->id);
				$p->isotopid	= $subcategory->slug;
			}
		}*/
		//grab the products using the pagination lib
		$data['products']	= $this->Product_model->get_products($data['category']->id, 12, $page);
		foreach ($data['products'] as &$p)
		{
			$p->images	= (array)json_decode($p->images);
			$p->options	= $this->Option_model->get_product_options($p->id);
		}

		$this->load->view('category', $data);
	}
	
	function product($id)
	{
		//get the product
		$data['product']	= $this->Product_model->get_product($id);
		
		if(!$data['product'] || $data['product']->enabled==0)
		{
			show_404();
		}

		// load the digital language stuff
		$this->lang->load('digital_product');
		
		$data['options']	= $this->Option_model->get_product_options($data['product']->id);
		
		$data['pdf_options']	= $this->Digital_Product_model->get_product_pdf_group_options($data['product']->id);
		
		$data['colors']	= $this->Color_model->get_products($data['product']->id);
		
		$related			= (array)json_decode($data['product']->related_products);
		$data['related']	= array();
		foreach($related as $r)
		{
			$r					= $this->Product_model->get_product($r);
			if($r)
			{
				$r->images			= (array)json_decode($r->images);
				$r->options			= $this->Option_model->get_product_options($r->id);
				$data['related'][]	= $r;
			}
			
		}
		$data['posted_options']	= $this->session->flashdata('option_values');

		$data['page_title']			= $data['product']->name;
		$data['meta']				= $data['product']->meta;
		$data['seo_title']			= $data['product']->seo_title;
			
		if($data['product']->images == 'false')
		{
			$data['product']->images = array();
		}
		else
		{
			$data['product']->images	= array_values((array)json_decode($data['product']->images));
		}

		if($data['product']->icons == 'false')
		{
			$data['product']->icons = array();
		}
		else
		{
			$data['product']->icons	= array_values((array)json_decode($data['product']->icons));
		}

		$data['gift_cards_enabled'] = $this->gift_cards_enabled;
					
		$this->load->view('product', $data);
	}
	
	 function colors($id)
	{
		//get the product
		$data['product']	= $this->Color_model->get_product($id);
		
		if(!$data['product'] || $data['product']->enabled==0)
		{
			show_404();
		}

		// load the digital language stuff
		$this->lang->load('digital_product');
		
		$data['options']	= $this->Option_model->get_product_options($data['product']->id);
		
		$related			= (array)json_decode($data['product']->related_products);
		$data['related']	= array();
		foreach($related as $r)
		{
			$r					= $this->Product_model->get_product($r);
			if($r)
			{
				$r->images			= (array)json_decode($r->images);
				$r->options			= $this->Option_model->get_product_options($r->id);
				$data['related'][]	= $r;
			}
			
		}
		$data['posted_options']	= $this->session->flashdata('option_values');

		$data['page_title']			= $data['product']->name;
		$data['meta']				= $data['product']->meta;
		$data['seo_title']			= $data['product']->seo_title;
			
		if($data['product']->images == 'false')
		{
			$data['product']->images = array();
		}
		else
		{
			$data['product']->images	= array_values((array)json_decode($data['product']->images));
		}

		$data['gift_cards_enabled'] = $this->gift_cards_enabled;
					
		$this->load->view('colors', $data);
	}
	
	
	
	function add_to_cart()
	{
		// Get our inputs
		$product_id		= $this->input->post('id');
		$quantity 		= $this->input->post('quantity');
		$post_options 	= $this->input->post('option');
		$cartkey		= $this->input->post('cartkey');
		
		$product_color		= $this->input->post('imagecolor');
		


		// Get a cart-ready product array
		$product = $this->Product_model->get_cart_ready_product($product_id, $quantity);
		

		//if out of stock purchase is disabled, check to make sure there is inventory to support the cart.
		if(!$this->config->item('allow_os_purchase') && (bool)$product['track_stock'])
		{
			$stock	= $this->Product_model->get_product($product_id);
			
			//loop through the products in the cart and make sure we don't have this in there already. If we do get those quantities as well
			$items		= $this->go_cart->contents();
			$qty_count	= $quantity;
			foreach($items as $item)
			{
				if(intval($item['id']) == intval($product_id))
				{
					$qty_count = $qty_count + $item['quantity'];
				}
			}

			
			if($stock->quantity < $qty_count)
			{
				//we don't have this much in stock
				$this->session->set_flashdata('error', sprintf(lang('not_enough_stock'), $stock->name, $stock->quantity));
				$this->session->set_flashdata('cartkey', $cartkey);
				$this->session->set_flashdata('quantity', $quantity);
				$this->session->set_flashdata('option_values', $post_options);

				redirect($this->Product_model->get_slug($product_id));
			}
		}

		
		// Validate Options 
		// this returns a status array, with product item array automatically modified and options added
		//  Warning: this method receives the product by reference
		$status = $this->Option_model->validate_product_options($product, $post_options);
		
		// don't add the product if we are missing required option values
		if( ! $status['validated'])
		{
			//if the cartkey does not exist, this will simply be blank
			$this->session->set_flashdata('cartkey', $cartkey);
			$this->session->set_flashdata('quantity', $quantity);
			$this->session->set_flashdata('error', $status['message']);
			$this->session->set_flashdata('option_values', $post_options);			
		
			redirect($this->Product_model->get_slug($product_id));
		
		} else {
		
			//Add the original option vars to the array so we can edit it later
			$product['post_options']	= $post_options;
			$product['product_color']	= $product_color;
			$product['cartkey']			= $cartkey;
			$product['is_gc']			= false;
			// Add the product item to the cart, also updates coupon discounts automatically
			$this->go_cart->insert($product);
		
			// go go gadget cart!
			redirect('cart/view_cart');
		}
	}
	
	function view_cart()
	{
		
		$data['page_title']	= 'Cart';
		$data['gift_cards_enabled'] = $this->gift_cards_enabled;
		
		$this->load->view('view_cart', $data);
	}
	
	function remove_item($key)
	{
		//drop quantity to 0
		$this->go_cart->update_cart(array($key=>0));
		
		redirect('cart/view_cart');
	}
	
	function update_cart($redirect = false)
	{
		//if redirect isn't provided in the URL check for it in a form field
		if(!$redirect)
		{
			$redirect = $this->input->post('redirect');
		}
		
		// see if we have an update for the cart
		$item_keys		= $this->input->post('cartkey');
		$coupon_code	= $this->input->post('coupon_code');
		$gc_code		= $this->input->post('gc_code');
			
			
		//get the items in the cart and test their quantities
		$items			= $this->go_cart->contents();
		$new_key_list	= array();
		//first find out if we're deleting any products
		foreach($item_keys as $key=>$quantity)
		{
			if(intval($quantity) === 0)
			{
				//this item is being removed we can remove it before processing quantities.
				//this will ensure that any items out of order will not throw errors based on the incorrect values of another item in the cart
				$this->go_cart->update_cart(array($key=>$quantity));
			}
			else
			{
				//create a new list of relevant items
				$new_key_list[$key]	= $quantity;
			}
		}
		$response	= array();
		foreach($new_key_list as $key=>$quantity)
		{
			$product	= $this->go_cart->item($key);
			//if out of stock purchase is disabled, check to make sure there is inventory to support the cart.
			if(!$this->config->item('allow_os_purchase') && (bool)$product['track_stock'])
			{
				$stock	= $this->Product_model->get_product($product['id']);
			
				//loop through the new quantities and tabluate any products with the same product id
				$qty_count	= $quantity;
				foreach($new_key_list as $item_key=>$item_quantity)
				{
					if($key != $item_key)
					{
						$item	= $this->go_cart->item($item_key);
						//look for other instances of the same product (this can occur if they have different options) and tabulate the total quantity
						if($item['id'] == $stock->id)
						{
							$qty_count = $qty_count + $item_quantity;
						}
					}
				}
				if($stock->quantity < $qty_count)
				{
					if(isset($response['error']))
					{
						$response['error'] .= '<p>'.sprintf(lang('not_enough_stock'), $stock->name, $stock->quantity).'</p>';
					}
					else
					{
						$response['error'] = '<p>'.sprintf(lang('not_enough_stock'), $stock->name, $stock->quantity).'</p>';
					}
				}
				else
				{
					//this one works, we can update it!
					//don't update the coupons yet
					$this->go_cart->update_cart(array($key=>$quantity));
				}
			}
			else
			{
				$this->go_cart->update_cart(array($key=>$quantity));
			}
		}
		
		//if we don't have a quantity error, run the update
		if(!isset($response['error']))
		{
			//update the coupons and gift card code
			$response = $this->go_cart->update_cart(false, $coupon_code, $gc_code);
			// set any messages that need to be displayed
		}
		else
		{
			$response['error'] = '<p>'.lang('error_updating_cart').'</p>'.$response['error'];
		}
		
		
		//check for errors again, there could have been a new error from the update cart function
		if(isset($response['error']))
		{
			$this->session->set_flashdata('error', $response['error']);
		}
		if(isset($response['message']))
		{
			$this->session->set_flashdata('message', $response['message']);
		}
		
		if($redirect)
		{
			redirect($redirect);
		}
		else
		{
			redirect('cart/view_cart');
		}
	}


	public function checkout(){

		$this->load->helper('captcha');
		$data['page_title']	= 'Checkout';

		$values = array(
			'word' => '',
			'img_path' => './images/',
			'img_url' => base_url() .'images/',
			'font_path' => base_url() . 'system/fonts/texb.ttf',
			'img_width' => '200',
			'img_height' => 50,
			'expiration' => 3600,
	        'word_length'   => 5,
	        'font_size'     => 30,
	        'pool'          => '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ',
		);

		$data['captcha'] = create_captcha($values);
		
		$this->session->set_userdata('captcha_answer',$data['captcha']['word']);


		$this->load->view('checkout', $data);

	}
	
	/***********************************************************
			Gift Cards
			 - this function handles adding gift cards to the cart
	***********************************************************/
	
	function giftcard()
	{
		if(!$this->gift_cards_enabled) redirect('/');
		
		$this->load->helper('utility_helper');
		
		// Load giftcard settings
		$gc_settings = $this->Settings_model->get_settings("gift_cards");
				
		$this->load->library('form_validation');
		
		$data['allow_custom_amount']	= (bool) $gc_settings['allow_custom_amount'];
		$data['preset_values']			= explode(",",$gc_settings['predefined_card_amounts']);
		
		if($data['allow_custom_amount'])
		{
			$this->form_validation->set_rules('custom_amount', 'lang:custom_amount', 'numeric');
		}
		
		$this->form_validation->set_rules('amount', 'lang:amount', 'required');
		$this->form_validation->set_rules('preset_amount', 'lang:preset_amount', 'numeric');
		$this->form_validation->set_rules('gc_to_name', 'lang:recipient_name', 'trim|required');
		$this->form_validation->set_rules('gc_to_email', 'lang:recipient_email', 'trim|required|valid_email');
		$this->form_validation->set_rules('gc_from', 'lang:sender_email', 'trim|required');
		$this->form_validation->set_rules('message', 'lang:custom_greeting', 'trim|required');
		
		if ($this->form_validation->run() == FALSE)
		{
			$data['error']				= validation_errors();
			$data['page_title']			= lang('giftcard');
			$data['gift_cards_enabled']	= $this->gift_cards_enabled;
			$this->load->view('giftcards', $data);
		}
		else
		{
			
			// add to cart
			
			$card['price'] = set_value(set_value('amount'));
			
			$card['id']				= -1; // just a placeholder
			$card['sku']			= lang('giftcard');
			$card['base_price']		= $card['price']; // price gets modified by options, show the baseline still...
			$card['name']			= lang('giftcard');
			$card['code']			= generate_code(); // from the utility helper
			$card['excerpt']		= sprintf(lang('giftcard_excerpt'), set_value('gc_to_name'));
			$card['weight']			= 0;
			$card['quantity']		= 1;
			$card['shippable']		= false;
			$card['taxable']		= 0;
			$card['fixed_quantity'] = true;
			$card['is_gc']			= true; // !Important
			$card['track_stock']	= false; // !Imporortant
			
			$card['gc_info'] = array("to_name"	=> set_value('gc_to_name'),
									 "to_email"	=> set_value('gc_to_email'),
									 "from"		=> set_value('gc_from'),
									 "personal_message"	=> set_value('message')
									 );
			
			// add the card data like a product
			$this->go_cart->insert($card);
			
			redirect('cart/view_cart');
		}
	}

	public function subscribe(){

		$this->load->view('subscribe');
	}

	function news_and_events()
	{
	    
	    $this->load->model(array('News_model'));
	    $data['news'] = $this->News_model->get_pages();
	    $this->load->view('news', $data);
	}


	public function catalogues(){

		$data = array();

		$this->lang->load('digital_product');

		$data['products'] = $this->Digital_Product_model->get_catalogue_list();
		/*print_r($data);
		die;*/

		$this->load->view('catalogues', $data);
	}


	public function downloadCatalogue()
	{
	    
	    $defaultPassword = '123456';
	    
	    
	    $token = $this->input->post('token');
	    $password = $this->input->post('password');
	    
	    if(empty($token)){
	        $this->session->set_flashdata('error', 'Sorry! Token not found!');
	        redirect('catalogues');
	        die;
	    }
	    
	    if(empty($password)){
	        $this->session->set_flashdata('error', 'Sorry! The Password field is required!');
	        redirect('catalogues');
	        die;
	    }
	    
	    if($password != $defaultPassword){
	        $this->session->set_flashdata('error', 'Sorry! The Password is not valid!');
	        redirect('catalogues');
	        die;
	    }
	    
	    $this->lang->load('digital_product');
	    $this->load->helper('download');
        
        $ci =& get_instance();
        
        $ci->db->where("md5(CONCAT(id)) = '".$token."'");
        $row = $ci->db->get('digital_products')->row();
        
        $path = FCPATH . 'uploads/digital_uploads/'.$row->filename;
        
        if(is_file($path))
        {
            
            $this->load->helper('file');

            $mime = get_mime_by_extension($path);
            
            $name = $row->title.time().'.pdf';
            //$name = $row->filename;
        
            // Build the headers to push out the file properly.
            header('Pragma: public');     // required
            header('Expires: 0');         // no cache
            header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
            header('Last-Modified: '.gmdate ('D, d M Y H:i:s', filemtime ($path)).' GMT');
            header('Cache-Control: private',false);
            header('Content-Type: '.$mime);  // Add the mime type from Code igniter.
            header('Content-Disposition: attachment; filename="'.basename($name).'"');  // Add the file name
            header('Content-Transfer-Encoding: binary');
            header('Content-Length: '.filesize($path)); // provide file size
            header('Connection: close');
            readfile($path); // push it out
            exit();
            
        }
      
	}


	public function compliance()
	{
		$data = array();

		$data['homepage']			= false;

		$this->load->model('Banner_model');
		$data['boxes']			= $this->Banner_model->get_homepage_banners_by_position(1000,'compliance');
		
		$this->load->view('compliance', $data);
	}

	public function factoryView()
	{
		$data = array();

		$data['homepage']			= false;

		$this->load->model('Banner_model');
		$data['boxes']			= $this->Banner_model->get_homepage_banners_by_position(1000,'factory-view');
		
		$this->load->view('factory-view', $data);
	}



	
}