<?php

Class Digital_Product_Model extends CI_Model {
	
	function __construct()
	{
		parent::__construct();
		$this->lang->load('digital_product');
	}
	
	// Return blank record array
	function new_file()
	{
		return array(
					'id'=>'',
					'filename'=>'',
					'max_downloads'=>'',
					'title'=>'',
					'description'=>'',
					'size'=>'',
					'catalogue_type'=>''
					);
	}
	
	// Get files list
	function get_list()
	{
		
		$list = $this->db->get('digital_products')->result();
		
		foreach($list as &$file)
		{
			// identify if the record is missing it's file content
			$file->verified = $this->verify_content($file->filename);
		}
		
		return $list;
	}

	function get_catalogue_list()
	{
		
		$this->db->where('catalogue_type', 'catalogue');
		$list = $this->db->get('digital_products')->result();
		
		foreach($list as &$file)
		{
			// identify if the record is missing it's file content
			$file->verified = $this->verify_content($file->filename);
		}
		
		return $list;
	}

	
	// Get file record
	function get_file_info($id)
	{
		return $this->db->where('id', $id)->get('digital_products')->row();
	}
	
	// Verify upload path
	function verify_file_path()
	{
		return is_writable('uploads/digital_products');
	}
	
	// Verify file content
	function verify_content($filename)
	{
		return file_exists('uploads/digital_products'.'/'.$filename);
	}
	
	// Save/Update file record
	function save($data)
	{
		if(isset($data['id']))
		{
			$this->db->where('id', $data['id'])->update('digital_products', $data);
			return $data['id'];
		} else {
			$this->db->insert('digital_products', $data);
			return $this->db->insert_id();
		}
	}


	function get_product_pdf_options($product_id)
	{
		$this->db->where('product_id',$product_id); 
		$this->db->order_by('id', 'ASC');
		
		$result	= $this->db->get('pdf_options');
		
		$return = array();
		foreach($result->result() as $option)
		{
			$option->values	= $this->get_option_pdf_values($option->id);
			$return[]	= $option;
		}
		return $return;
	}

	function get_product_pdf_group_options($product_id='')
	{
		$this->db->where('product_id',$product_id); 
		$this->db->order_by('id', 'ASC');
		//$this->db->group_by('name');
		
		$result	= $this->db->get('pdf_options');
		
		$return = array();
		foreach($result->result() as $option)
		{
			$option->values	= $this->get_option_pdf_values($option->id);
			$return[]	= $option;
		}
		return $return;
	}

	function get_option_pdf_values($option_id)
	{
		$this->db->where('option_id',$option_id); 
		$this->db->order_by('id', 'ASC');
		return $this->db->get('pdf_options_values')->result();
	}
	
	// Add product association
	function associate_pdf($data)
	{


		$checkExists = $this->db->where('product_id', $data['product_id'])->where('name', $data['name'])->get('pdf_options')->row();
		if(!empty($checkExists)){

			if(!empty($data)){

				if(!empty($data['images'])){
					foreach($data['images'] as $img){

						$this->db->insert('pdf_options_values', array(
							'option_id'=> $checkExists->id, 
							'product_id'=> $data['product_id'], 
							'name'=> $img['name'], 
							'size' => $img['size'],
							'filename' => $img['filename'],
							'version' => 1,
							'sequence' => 1,
							'max_downloads' => 100,
						));
					}
				}
			}

			// echo '<pre>';
			// print_r($checkExists);
			// print_r($data);

		}else{

			if(!empty($data)){
			
				$this->db->insert('pdf_options', array(
					'product_id'=> $data['product_id'], 
					'name'=>$data['name'], 
					'type' => $data['type'],
					'required' => 0,
					'sequence' => 1,
				));

				$option_id = $this->db->insert_id();

				if(!empty($data['images'])){
					foreach($data['images'] as $img){

						$this->db->insert('pdf_options_values', array(
							'option_id'=> $option_id, 
							'product_id'=> $data['product_id'], 
							'name'=> $img['name'], 
							'size' => $img['size'],
							'filename' => $img['filename'],
							'version' => 1,
							'sequence' => 1,
							'max_downloads' => 100,
						));
					}
				}
			}

		}
		

		//
		/**/
		
		
	}

	function associate($file_id, $product_id)
	{
		$this->db->insert('pdf_options', array('product_id'=>$product_id, 'file_id'=>$file_id));
	}

	function disassociate_pdf($product_id=false)
	{
		
		if($product_id)
		{
			$data['product_id'] = $product_id;
		}
		
		$this->db->where($data)->delete('pdf_options');
		$this->db->where($data)->delete('pdf_options_values');
	}

	function disassociate_pdf_with_options($section_id=false)
	{
		
		
		$this->db->where('id', $section_id)->delete('pdf_options');
		$this->db->where('option_id', $section_id)->delete('pdf_options_values');
	}

	function disassociate_pdf_options($id=false)
	{
		$this->db->where('id', $id)->delete('pdf_options_values');
	}


	
	// Remove product association (all or by product)
	function disassociate($file_id, $product_id=false)
	{
		
		if($product_id)
		{
			$data['product_id'] = $product_id;
		}
		if($file_id)
		{
			$data['file_id']	= $file_id;
		}
		$this->db->where($data)->delete('products_files');
	}
	
	function get_associations_by_file($id)
	{
		return $this->db->where('file_id', $id)->get('products_files')->result();
	}
	
	function get_associations_by_product($product_id)
	{
		return $this->db->where('product_id', $product_id)->get('products_files')->result();
	}
	
	// Delete file record & content
	function delete($id)
	{
		$this->load->model('product_model');
		
		$info = $this->get_file_info($id);
		
		if(!$info)
		{
			return false;
		}
		
		// remove file
		if($this->verify_content($info->filename))
		{
			unlink('uploads/digital_products/'.$info->filename);
		}
		
		// Disable products that are associated with this file
		//  to prevent users purchasing a product with deleted media
		$product_associations  = $this->get_associations_by_file($id);
		foreach($product_associations as $p)
		{
			$save['id']			= $p->product_id;
			$save['enabled']	= 0;
			$this->product_model->save($save);
		}
		
		// Remove db associations
		$this->db->where('id', $id)->delete('digital_products');
		$this->disassociate($id);
	}
	
	// Accepts an array of file lists for products purchased
	//  and sets up the list of available downloads for the customer
	//  uses customer id if available, also creates a package code
	//  that can be sent to non registered customers
	function add_download_package($package, $order_id)
	{
		$this->load->helper('utility_helper');
		
		// get customer stuff
		$customer = $this->go_cart->customer();
		if(!empty($customer['id']))
		{
			$new_package['customer_id'] = $customer['id'];
		} else {
			$new_package['customer_id'] = 0;
		}
		
		$new_package['order_id'] = $order_id;
		$new_package['code']	= generate_code();
		
		// save master package record
		$this->db->insert('download_packages',$new_package);
		
		$package_id = $this->db->insert_id();
		
		// save the db data here
		$files_list = array();
		
		// use this to prevent inserting duplicates
		// in case a file is shared across products
		$ids = array();
		
		// build files records list
		foreach($package as $product_list)
		{
			foreach($product_list as $f)
			{
				if(!isset($ids[$f->file_id]))
				{
					$file['package_id'] = $package_id;
					$file['file_id'] = $f->file_id;
					$file['link'] = md5($f->file_id . time() . $new_package['customer_id']); // create a unique download key for each file
					
					$files_list[] = $file;
				}
			}
		}
		
		$this->db->insert_batch('download_package_files', $files_list);
		
		// save the master record to include links in the order email
		$this->go_cart->save_order_downloads($new_package);
	}
	
	// Retrieve user's download packages
	//  send back an array indexed by order number
	function get_user_downloads($customer_id)
	{
		$result = $this->db->where('customer_id', $customer_id)->get('download_packages')->result();
		
		$downloads = array();
		foreach($result as $r)
		{
			$downloads[$r->order_id] = $this->get_package_files($r->id); 
		}
		
		return $downloads;
	}
	
	// Retrieve non-member download by code
	//   format array exactly as by user
	function get_downloads_by_code($code)
	{
		$row =  $this->db->where('code', $code)->get('download_packages')->row();
		
		if($row)
		{
			return array(	
							$row->order_id => $this->get_package_files($row->id)
						);
		}
	}
	
	// get the files in a package
	function get_package_files($package_id)
	{
		
		return $this->db->select('*')
						->from('download_package_files as a')
						->join('digital_products as b', 'a.file_id=b.id')
						->where('package_id', $package_id)
						->get()
						->result();
	}
	
	// get file info for download by the link code
	//  increment the download counter
	function get_file_info_by_link($link)
	{
		
		$record = $this->db->from('digital_products as a')
						->join('download_package_files as b', 'a.id=b.file_id')
						->where('link', $link)
						->get()
						->row();
						
		return $record;
		
	}
	
	
	function touch_download($link)
	{
		$this->db->where('link', $link)->set('downloads','downloads+1', false)->update('download_package_files');
	}
}