<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class flatrate
{
	var $CI;

	function __construct()
	{
		$this->CI =& get_instance();
		$this->CI->lang->load('flatrate');
	}
	
	function get_order_weight()
	{
		return $this->CI->go_cart->order_weight();
	}
	
	function get_order_price()
	{
		return $this->CI->go_cart->subtotal();
	}
	
	function rates()
	{
		
		//$method either equals weight or price	
		//this can be set either from some sort of admin panel, or directly here.
		$this->CI->load->library('session');
		
		// get customer info
		$customer = $this->CI->go_cart->customer();
		
		//if there is no address set then return blank
		if(empty($customer['ship_address']))
		{
			return array();
		}
		
		$city_name= $customer['ship_address']['city'];
		//rates function should return an array of rates/prices
		//this is so a UPS function could perhaps return multiple shipping rates
		//setting up some sort of database setting for this is ok
		$settings	= $this->CI->Settings_model->get_settings('flatrate');


        if(!$settings['enabled'] && $settings['enabled'] == 0)
		{
			return array();
		}
		
		
		$order_weight	= $this->get_order_weight();
		$city_rate =      $this->CI->Location_model->get_zone_rate($city_name);
		
		
		
		
		if($order_weight<=0.5)
		{
		$shipping_rate = $city_rate->rate_kg1;
		return array('Flat Rate'=> $shipping_rate);
		}
		
		
		if($order_weight<=1)
		{
		$shipping_rate =$city_rate->rate_kg2;
		return array('Flat Rate'=> $shipping_rate);
		}
		
		
		if($order_weight>1)
		{
			$shipping_rate = $city_rate->rate_kg2;
			
			for($i=2;$i<=$order_weight;$i++)
			{
		     $shipping_rate +=$city_rate->shipping_rate;
			}
		     return array('Flat Rate'=> $shipping_rate);
		}
		
		
		
		
		
		
		
		
		
		
	}
	
	function install()
	{
		//set a default blank setting for flatrate shipping
		$this->CI->Settings_model->save_settings('flatrate', array('rate'=>''));
		$this->CI->Settings_model->save_settings('flatrate', array('enabled'=>'0'));
	}
	
	function uninstall()
	{
		$this->CI->Settings_model->delete_settings('flatrate');
	}
	
	function form($post	= false)
	{
		//this same function processes the form
		if(!$post)
		{
			$settings	= $this->CI->Settings_model->get_settings('flatrate');
			$rate		= $settings['rate'];
		}
		else
		{
			$rate		= $post['rate'];
		}
		
		$form	= '<table><tr><td>'.lang('rate').':</td><td><input type="text" name="rate" value="'.$rate.'"  class="gc_tf1"/></td></tr>
		<tr><td>'.lang('enabled').': </td><td><select name="enabled">';
		if($settings['enabled'] == 1)
		{
			$enable		= ' selected="selected"';
			$disable	= '';
		}
		else
		{
			$enable		= '';
			$disable	= ' selected="selected"';
		}
		$form	.= '<option value="1"'.$enable.'>'.lang('enabled').'</option>
					<option value="0"'.$disable.'>'.lang('disabled').'</option>';
		$form	.= '</select></td></tr>
		</table>';
		return $form;
	}
	
	function check()
	{	
		$error	= false;
		
		if(!is_numeric($_POST['rate']))
		{
			$error	.= '<div>'.lang('val_err').'</div>';
		}		
		
		//count the errors
		if($error)
		{
			return $error;
		}
		else
		{
			//we save the settings if it gets here
			$this->CI->Settings_model->save_settings('flatrate', array('rate'=>$_POST['rate'], 'enabled'=>$_POST['enabled']));
			
			return false;
		}
	}
}
