<script type="text/javascript">
$(document).ready(function() {	
	//disable the form elements under billing if the checkbox is checked
	if($('#different_address').is(':checked'))
	{
		toggle_billing_address_form(true);
	}
	
	//add the disabled class to to disabled fields
	$('*:disabled').addClass('disabled');

	// automatically copy values when the checkbox is checked
	$('.ship').change(function(){
		if($('#different_address').is(':checked'))
		{
			copy_shipping_address();
		}
	});	
	
	// populate zone menu with country selection
	$('#ship_country_id').change(function(){
			populate_zone_menu('ship');
		});

	$('#bill_country_id').change(function(){
			populate_zone_menu('bill');
		});	
		
		// populate zone menu with country selection
	$('#ship_zone_id').change(function(){
			populate_zone_area_menu('ship');
		});
		
	

});


// context is ship or bill
function populate_zone_area_menu(context, value)
{
	$.post('<?php echo site_url('locations/get_zone_area_menu');?>',{id:$('#'+context+'_zone_id').val()}, function(data) {
		$('#'+context+'_city').html(data);
	});
}
// context is ship or bill
function populate_zone_menu(context, value)
{
	$.post('<?php echo site_url('locations/get_zone_menu');?>',{id:$('#'+context+'_country_id').val()}, function(data) {
		$('#'+context+'_zone_id').html(data);
		
		//if the ship country is changed, and copy shipping address is checked, then reset the billing address to blank
		if(context == 'ship' && $('#different_address').is(':checked'))
		{
			$('#bill_zone_id').html(data).val($('#bill_zone_id option:first').val());
		}
	});
}
function toggle_billing_address_form(checked)
{
	if(!checked)
	{
		clear_billing_address();
		$('.bill').attr('disabled', false);
		$('.bill').removeClass('disabled');
	}
	else
	{
		copy_shipping_address();
		$('.bill').attr('disabled', true);
		$('.bill').addClass('disabled');
	}
}

function clear_billing_address()
{
	$('.bill').val('');
}

function copy_shipping_address()
{
	$('#bill_company').val($('#ship_company').val());
	$('#bill_firstname').val($('#ship_firstname').val());
	$('#bill_lastname').val($('#ship_lastname').val());
	$('#bill_address1').val($('#ship_address1').val());
	$('#bill_address2').val($('#ship_address2').val());
	$('#bill_city').val($('#ship_city').val());
	$('#bill_zip').val($('#ship_zip').val());
	$('#bill_phone').val($('#ship_phone').val());
	$('#bill_email').val($('#ship_email').val());
	$('#bill_country_id').val($('#ship_country_id').val());

	// repopulate and set zone field
	$('#bill_zone_id').html($('#ship_zone_id').html());
	$('#bill_zone_id').val($('#ship_zone_id').val());
}

function save_customer()
{
	$('#save_customer_loader').show();
	// temporarily enable the billing fields (if disabled)
	if($('#different_address').is(':checked'))
	{
		$('.bill').attr('disabled', false);
		$('.bill').removeClass('disabled');
	}
	//send data to server
	form_data  = $('#customer_info_form').serialize();
	
	$.post('<?php echo site_url('checkout/save_customer') ?>', form_data, function(response)
	{
		if(typeof response != "object") // error
		{
			display_error('customer', '<?php echo lang('communication_error');?>');
			return;
		}
		
		if(response.status=='success')
		{
			//populate the information from ajax, so someone cannot use developer tools to edit the form after it's saved
			$('#customer_info_fields').html(response.view);
			
			$('input:button, button').button();			
			 // and update the summary to show proper tax information / discounts
			 update_summary();
		}
		else if(response.status=='error')
		{
			display_error('customer', response.error);
			$('#save_customer_loader').hide();
		}
	}, 'json');
}


function save_billaddress()
{
	$('#save_customer_loader').show();
	//send data to server

	$.post("<?php echo site_url('secure/address_form');?>/"+$('#f_id').val(), {	company: $('#bill_company').val(),
																				firstname: $('#bill_firstname').val(),
																				lastname: $('#bill_lastname').val(),
																				email: $('#bill_email').val(),
																				phone: $('#bill_phone').val(),
																				address1: $('#bill_address1').val(),
																				address2: $('#bill_address2').val(),
																				city: $('#bill_city').val(),
																				country_id: $('#bill_country_id').val(),
																				zone_id: $('#bill_zone_id').val(),
																				zip: $('#bill_zip').val()
																				},
		function(data){
			if(data == 1)
			{
				//window.location = "<?php echo site_url('secure/my_account');?>";
				$('#save_customer_loader').hide();
			}
			else
			{
				$('#form_error').show().html(data);
				//call resize twice to fix a wierd bug where the height is overcompensated
				$.fn.colorbox.resize();
			}
		});
}
function save_shipaddress()
{
	$('#save_customer_loader').show();
	//send data to server

	$.post("<?php echo site_url('secure/address_form');?>/"+$('#f_id').val(), {	company: $('#ship_company').val(),
																				firstname: $('#ship_firstname').val(),
																				lastname: $('#ship_lastname').val(),
																				email: $('#ship_email').val(),
																				phone: $('#ship_phone').val(),
																				address1: $('#ship_address1').val(),
																				address2: $('#ship_address2').val(),
																				city: $('#ship_city').val(),
																				country_id: $('#ship_country_id').val(),
																				zone_id: $('#ship_zone_id').val(),
																				zip: $('#ship_zip').val()
																				},
		function(data){
			if(data == 1)
			{
				//window.location = "<?php echo site_url('secure/my_account');?>";
				$('#save_customer_loader').hide();
			}
			else
			{
				$('#form_error').show().html(data);
				//call resize twice to fix a wierd bug where the height is overcompensated
				$.fn.colorbox.resize();
			}
		});
}
</script>
<?php /* Only show this javascript if the user is logged in */ ?>
<?php if($this->Customer_model->is_logged_in(false, false)) : ?>
<script type="text/javascript">
	
	var address_type = 'ship';
	$(document).ready(function(){
		$('.address_picker').click(function(){
			$.colorbox({href:'#address_manager', inline:true, height:'400px'});
			address_type = $(this).attr('rel');
		});
	});

	<?php
	$add_list = array();
	foreach($customer_addresses as $row) {
		// build a new array
		$add_list[$row['id']] = $row['field_data'];
	}
	$add_list = json_encode($add_list);
	echo "eval(addresses=$add_list);";
	?>
		
	function populate_address(address_id)
	{
		if(address_id=='') return;

		// update the visuals

		// - this is redundant, but it updates the visuals before the operation begins
		if(shipping_required && address_type=='ship')
		{
			$('#shipping_loading').show();
			$('#shipping_method_list').hide();
		}

		// - populate the fields
		$.each(addresses[address_id], function(key, value){
			$('#'+address_type+'_'+key).val(value);

			// repopulate the zone menu and set the right value if we change the country
			if(key=='zone_id')
			{
				zone_id = value;
			}
		});	
		
		// - save the address id
		$('#'+address_type+'_address_id').val(address_id);

		// repopulate the zone list, set the right value, then copy all to billing
		$.post('<?php echo site_url('locations/get_zone_menu');?>',{id:$('#'+address_type+'_country_id').val()}, function(data) {
			// - uncheck the option box if they choose a billing address
			if(address_type=='bill')
			{
				$('#different_address').attr('checked', false);
				$('.bill').attr('disabled', false);
				$('.bill').removeClass('disabled');
				$('#bill_zone_id').html(data);
				$('#bill_zone_id').val(zone_id);
			} 
			else 
			{
				// set the right zone values
				$('#ship_zone_id').html(data);
				$('#ship_zone_id').val(zone_id);

				if($('#different_address').is(':checked'))
				{
					// copy the rest of the fields
					copy_shipping_address();
				}	
			}
		});		
	}
	
</script>
<?php endif;?>

<?php
$countries = $this->Location_model->get_countries_menu();

if(!empty($customer['ship_address']['country_id']))
{
	$ship_zone_menu	= $this->Location_model->get_zones_menu($customer['ship_address']['country_id']);
}
else
{
	// if this is set, it means we've got a blank address. Set the state field to an empty initial value
	$ship_zone_menu = array(''=>'')+$this->Location_model->get_zones_menu(array_shift(array_keys($countries)));
}

if(!empty($customer['ship_address']['zone_id']))
{
	$ship_zone_area_menu	= $this->Location_model->get_zones_area_menu($customer['ship_address']['zone_id']);
}
else
{
	// if this is set, it means we've got a blank address. Set the state field to an empty initial value
	$ship_zone_area_menu = array(''=>'')+$this->Location_model->get_zones_area_menu(array_shift(array_keys($ship_zone_menu)));
}


if(!empty($customer['bill_address']['country_id']))
{
	$bill_zone_menu	= $this->Location_model->get_zones_menu($customer['bill_address']['country_id']);
}
else
{
	$bill_zone_menu = array(''=>'')+$this->Location_model->get_zones_menu(array_shift(array_keys($countries)));
}

//form elements

$b_company	= array('id'=>'bill_company', 'class'=>'bill input', 'name'=>'bill_company', 'value'=> @$customer['bill_address']['company']);
$b_address1	= array('id'=>'bill_address1', 'class'=>'bill input bill_req', 'name'=>'bill_address1', 'value'=>@$customer['bill_address']['address1']);
$b_address2	= array('id'=>'bill_address2', 'class'=>'bill input', 'name'=>'bill_address2', 'value'=> @$customer['bill_address']['address2']);
$b_first	= array('id'=>'bill_firstname', 'class'=>'bill input bill_req', 'name'=>'bill_firstname', 'value'=> @$customer['bill_address']['firstname']);
$b_last		= array('id'=>'bill_lastname', 'class'=>'bill input bill_req', 'name'=>'bill_lastname', 'value'=> @$customer['bill_address']['lastname']);
$b_email	= array('id'=>'bill_email', 'class'=>'bill input bill_req', 'name'=>'bill_email', 'value'=>@$customer['bill_address']['email']);
$b_phone	= array('id'=>'bill_phone', 'class'=>'bill input bill_req', 'name'=>'bill_phone', 'value'=> @$customer['bill_address']['phone']);
$b_city		= array('id'=>'bill_city', 'class'=>'bill input bill_req', 'name'=>'bill_city', 'value'=>@$customer['bill_address']['city']);
$b_zip		= array('id'=>'bill_zip', 'maxlength'=>'10', 'class'=>'bill input bill_req', 'name'=>'bill_zip', 'value'=> @$customer['bill_address']['zip']);


$s_company	= array( 'type'=>'hidden', 'id'=>'ship_company', 'class'=>'form-control', 'name'=>'ship_company', 'value'=> @$customer['ship_address']['company']);
$s_address1	= array('id'=>'ship_address1', 'class'=>'form-control ship_req', 'placeholder' => 'Enter Address*', 'name'=>'ship_address1', 'value'=>@$customer['ship_address']['address1']);
$s_address2	= array('id'=>'ship_address2', 'class'=>'form-control', 'placeholder' => 'Enter Address', 'name'=>'ship_address2', 'value'=> @$customer['ship_address']['address2']);
$s_first	= array('id'=>'ship_firstname', 'class'=>'form-control ship_req', 'placeholder' => 'First Name*', 'name'=>'ship_firstname', 'value'=> @$customer['firstname']);
$s_last		= array('id'=>'ship_lastname', 'class'=>'form-control ship_req', 'placeholder' => 'Last Name*', 'name'=>'ship_lastname', 'value'=> @$customer['lastname']);
$s_email	= array('id'=>'ship_email', 'class'=>'form-control ship_req', 'placeholder' => 'Email Address*','name'=>'ship_email', 'value'=>@$customer['email']);
if(@$customer['ship_address']['phone']!=''){
$s_phone	= array('type'=>'tel','id'=>'ship_phone', 'class'=>'form-control ship_req',  'placeholder' => 'Add Country Code before phone no. e.g 923XXXXXXXXXX', 'name'=>'ship_phone', 'value'=>@$customer['ship_address']['phone']);
}
else
{
	$s_phone	= array('type'=>'tel', 'id'=>'ship_phone', 'class'=>'form-control ship_req',  'placeholder' => 'Add Country Code before phone no. e.g 923XXXXXXXXXX', 'name'=>'ship_phone', 'value'=>'92');
}
$s_city		= array('id'=>'ship_city', 'class'=>'form-control ship_req','placeholder' => 'Enter City Name*',  'name'=>'ship_city', 'value'=>@$customer['ship_address']['city']);
$s_zip		= array('id'=>'ship_zip', 'maxlength'=>'10', 'class'=>'form-control ship_req', 'placeholder' => 'Enter Post Code*', 'name'=>'ship_zip', 'value'=> @$customer['ship_address']['zip']);

?>
<div class="title">
          <h4><strong>2.</strong>YOUR ADDRESS </h4>
</div>
<div id="customer_error_box" class="error" style="display:none"></div>
<div class="col-md-offset-3 col-md-5">
<form class="form-horizontal" id="customer_info_form">
 <div class="address-contents" id="shipping_address11">
 <div class="form-group">
 <div class="form-group">
				<?php if($this->Customer_model->is_logged_in(false, false)) : ?>
				<div>
					<input class="address_picker" type="hidden" value="<?php echo lang('choose_address');?>" rel="ship" />
				</div>
				<?php endif; ?>
			</div>
  <div class="form-group">
  <input type="hidden" name="ship_address_id" id="ship_address_id" />
  <?php echo form_input($s_company);?>
    <label for="inputEmail3" class="col-sm-3 control-label">First Name*</label>
    <div class="col-sm-9">
    <?php echo form_input($s_first);?>
    </div>
  </div>
  <div class="form-group">
    <label for="inputPassword3" class="col-sm-3 control-label">Last Name*</label>
    <div class="col-sm-9">
    <?php echo form_input($s_last);?>
    
    </div>
  </div>
  <div class="form-group">

    <label for="inputEmail3" class="col-sm-3 control-label" style="padding-top: 25px;">Email*</label>
    <div class="col-sm-9">
    <span style="display: block;font-size: 11px;color:#ff0000;margin-bottom: 5px;">
		In case you don't receive email from Us do check your junk mail folder.
    </span>
    <?php echo form_input($s_email);?>
     </div>
  </div>
  <div class="form-group">

    <label for="inputPassword3" class="col-sm-3 control-label" style="padding-top: 25px;">Phone Number*</label>
    <div class="col-sm-9">
    <span style="display: block;font-size: 11px;color:#ff0000;margin-bottom: 5px;">Use This 92300xxxxxxx format in order to proceed</span>
      <?php echo form_input($s_phone);?>
    </div>
  </div>

  
  
  
    <div class="form-group">
    <label for="inputPassword3" class="col-sm-3 control-label">Address*</label>
    <div class="col-sm-9">
     <?php echo form_input($s_address1).'<br/>'.form_input($s_address2);?>
    </div>
  </div>



  <div class="form-group">
    <label for="inputEmail3" class="col-sm-3 control-label">Country*</label>
    <div class="col-sm-9">
      <?php echo form_dropdown('ship_country_id',$countries, @$customer['ship_address']['country_id'], 'id="ship_country_id" class="form-control ship_req"');?>
     
    </div>
  </div>
  
    <div class="form-group">
    <label for="inputEmail3" class="col-sm-3 control-label"><?php echo lang('address_state');?><b class="r"> *</b></label>
    
    <div class="col-sm-9">
      <?php echo form_dropdown('ship_zone_id',$ship_zone_menu, @$customer['ship_address']['zone_id'], 'id="ship_zone_id" class="form-control ship_req"');?>
     
    </div>
  </div>
  
 
  <div class="form-group">
    <label for="inputEmail3" class="col-sm-3 control-label"><?php echo 'City';?><b class="r"> *</b></label>
    
    <div class="col-sm-9">
      <?php echo form_dropdown('ship_city', $ship_zone_area_menu, @$customer['ship_address']['city'], 'id="ship_city" class="form-control ship_req"');?>
     
    </div>
  </div>
  
  
 <!-- <div class="form-group">
    <label for="inputPassword3" class="col-sm-3 control-label"><?php// echo lang('address_city');?><b class="r"> *</b></label>
    <div class="col-sm-9">
    <?php // echo form_input($s_city);?>
    </div>
  </div>-->
  
 
  
    <div class="form-group">
    <label for="inputPassword3" class="col-sm-3 control-label"><?php echo lang('address_postcode');?><b class="r"> *</b></label>
    <div class="col-sm-9">
    <?php echo form_input($s_zip);?>
    </div>
  </div>

<div class="form-group" style="display:none;">
    <div class="col-sm-offset-3 col-sm-9">
      <div class="checkbox">
        <label>
         <input type="checkbox" id="different_address" name="ship_to_bill_address" value="yes" <?php echo set_checkbox('ship_to_bill_address', 'yes', @$customer['ship_to_bill_address']);?> onclick="toggle_billing_address_form(this.checked)"> <?php echo lang('use_address_for_billing');?>
        </label>
      </div>
    </div>
     </div>


  <div class="form-group">
    <div class="col-sm-offset-3 col-sm-9">
      <div class="checkbox">
        <label>
          <input type="checkbox"> I want to receive CA Sports Newsletter with <br/>
best deals and offers
        </label>
      </div>
    </div>
  </div>
    </div>
      
  <div id="billing_address" style="display:none;">
			<div class="form_wrap">
				<div style="font-weight:bold"><?php echo lang('billing_address')?></div>
			</div>
			<div class="form_wrap">
				<?php if($this->Customer_model->is_logged_in(false, false)) : ?>
				<div>
					<input class="address_picker" type="button" value="<?php echo lang('choose_address');?>" rel="bill" />
				</div>
				<?php endif; ?>
			</div>
			<div class="form_wrap">
				<input type="hidden" name="bill_address_id" id="bill_address_id" />
				<div class="shorter">
					<?php echo lang('address_company');?><br/>
					<?php echo form_input($b_company);?>
				</div>
				<div class="shorter">
					<?php echo lang('address_firstname');?><b class="r"> *</b><br/>
					<?php echo form_input($b_first);?>
				</div>
				<div class="shorter">
					<?php echo lang('address_lastname');?><b class="r"> *</b><br/>
					<?php echo form_input($b_last);?>
				</div>
			</div>
				
			<div class="form_wrap">
				<div class="shorter">
					<?php echo lang('address_email');?><b class="r"> *</b><br/>
					<?php echo form_input($b_email);?>
				</div>
				<div class="shorter">
					<?php echo lang('address_phone');?><b class="r"> *</b><br/>
					<?php echo form_input($b_phone);?>
				</div>
			</div>
			
			<div class="form_wrap">
				<div class="longer">
					<?php echo lang('address');?><b class="r"> *</b><br/>
					<?php echo form_input($b_address1).'<br/>'.form_input($b_address2);?>
				</div>
			</div>
			<div class="form_wrap">
				<div>
					<?php echo lang('address_country');?><b class="r"> *</b><br/>
					<?php echo form_dropdown('bill_country_id',$countries, @$customer['bill_address']['country_id'], 'id="bill_country_id" class="bill input bill_req"');?>
				</div>
				<div>
					<?php echo lang('address_state');?><b class="r"> *</b><br/>
					<?php echo form_dropdown('bill_zone_id',$bill_zone_menu, @$customer['bill_address']['zone_id'], 'id="bill_zone_id" class="bill input bill_req"');?>
				</div>
			</div>
				
			<div class="form_wrap">
				<div>
					<?php echo lang('address_city');?><b class="r"> *</b><br/>
					<?php echo form_input($b_city);?>
				</div>
	
				<div>
					<?php echo lang('address_postcode');?><b class="r"> *</b><br/>
					<?php echo form_input($b_zip);?>
				</div>
			</div>
			<div class="clear"></div>
		</div>
        </form>
</div>


	<div class="form-group">
    <div class="col-sm-offset-3 col-sm-9">
       <input class="btn proced" type="button" value="<?php echo 'Save & Continue';//lang('form_continue');?>" onclick="save_customer()"/>
       <input class="btn proced" type="hidden" value="<?php echo lang('form_saveshippingaddress');?>" onclick="save_shipaddress()"/>
       <input class="btn proced" type="hidden" value="<?php echo lang('form_savebillingaddress');?>" onclick="save_billaddress()"/>
       <img id="save_customer_loader" alt="loading" src="<?php echo base_url('images/ajax-loader.gif');?>" style="display:none;"/>
       </div>
  </div>
	<br style="clear:both;"/>

<?php if($this->Customer_model->is_logged_in(false, false)) : ?>
<div id="stored_addresses" style="display:none;">
	<div id="address_manager">
		<h3 style="text-align:center;"><?php echo lang('your_addresses');?></h3>
		<script type="text/javascript">
		$(document).ready(function(){
			$('#address_list .my_account_address:even').addClass('address_bg');
		});
		</script>
		<div id="address_list">
			
		<?php
		$c = 1;
		foreach($customer_addresses as $a):?>
			<div class="my_account_address" id="address_<?php echo $a['id'];?>">
				<div class="address_toolbar">
					<input type="button" class="choose_address" onclick="populate_address(<?php echo $a['id'];?>); $.colorbox.close()" value="<?php echo lang('form_choose');?>" />
				</div>
				<?php
				$b	= $a['field_data'];
				echo nl2br(format_address($b));
				?>
			</div>
		<?php endforeach;?>
		</div>
	</div>
</div>
<?php endif;?>